<?php

include_once 'conexao.php'; // Arquivo com a conexão ao banco de dados

class ModeloMonitoramentoOperacoes
{  
    // Função para adicionar uma nova operação no monitoramento
    static public function mdlAdicionarOperacao($dados)
    {
        // Preparar a consulta de inserção
        $stmt = Conexao::conectar()->prepare("INSERT INTO monitoramentodeoperacoesnaplataforma (operacao, ipDoUsuario, dataCadastro) VALUES (:operacao, :ipDoUsuario, :dataCadastro)");

        // Data e hora da operação
        $dataCadastro = date("Y-m-d H:i:s"); 

        // Vincular os parâmetros
        $stmt->bindParam(":operacao", $dados["operacao"], PDO::PARAM_STR);
        $stmt->bindParam(":ipDoUsuario", $dados["ipDoUsuario"], PDO::PARAM_STR);
        $stmt->bindParam(":dataCadastro", $dataCadastro, PDO::PARAM_STR);

        // Executar a consulta e verificar se ocorreu com sucesso
        if ($stmt->execute()) {
            return "ok";
        } else {
            // Retorna a mensagem de erro, se houver falha
            $errorInfo = $stmt->errorInfo();
            return $errorInfo[2];
        }
    }

    // Função para listar todas as operações no monitoramento
    static public function mdlListarOperacoes()
    {
        // Preparar a consulta de seleção
        $stmt = Conexao::conectar()->prepare("SELECT * FROM monitoramentodeoperacoesnaplataforma");

        // Executar a consulta
        $stmt->execute();

        // Retornar todos os registros como um array associativo
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    // Função para buscar operações por tipo de operação
    static public function mdlBuscarOperacoesPorOperacao($operacao)
    {
        // Preparar a consulta de seleção por operação
        $stmt = Conexao::conectar()->prepare("SELECT * FROM monitoramentodeoperacoesnaplataforma WHERE operacao = :operacao");

        // Vincular o parâmetro
        $stmt->bindParam(":operacao", $operacao, PDO::PARAM_STR);

        // Executar a consulta
        $stmt->execute();

        // Retornar os resultados como um array associativo
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
?>

